﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class FileChooser

    Private Shared defaultPath As String

    ''' <summary>
    ''' 所选的文件名
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property Filename() As String
        Get
            Return Me.FileTextBox.Text
        End Get
    End Property

    ''' <summary>
    ''' 要显示在 FileDialog 中的初始目录
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public Property InitialDirectory() As String
        Get
            If defaultPath Is Nothing Then
                defaultPath = My.Computer.FileSystem.CurrentDirectory
            End If
            Return defaultPath
        End Get
        Set(ByVal value As String)
            defaultPath = value
        End Set
    End Property

    ''' <summary>
    ''' 将该控件重置为其初始值
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Reset()
        Me.FileTextBox.Text = String.Empty
    End Sub

    ''' <summary>
    ''' 用选定的值填充 TextBox
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub FileBrowseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileBrowseButton.Click
        Dim fileDialog As New OpenFileDialog()
        fileDialog.InitialDirectory = Me.InitialDirectory
        If (fileDialog.ShowDialog() = DialogResult.OK) Then
            Me.FileTextBox.Text = fileDialog.FileName
            Me.InitialDirectory = System.IO.Path.GetDirectoryName(Filename)
        End If
    End Sub

End Class
